## Assets, Vulnerabilities, and Countermeasures

An Asset is anything of value to an organization - Example - IT Systems. 

A _vulnerability_ is a weakness in a system or its design that can be exploited by a threat.

A _threat_ is any potential danger to assets. A threat is realized when someone or something identifies a specific vulnerability and exploits it, creating exposure.

A _countermeasure_ is a safeguard that mitigates a potential risk.

Categorizing threats for the public domain: 

- Common Vulnerabilities and Exposures (CVE) is a dictionary of publicly known information security vulnerabilities and exposures. It can be found at [http://cve.mitre.org/](http://cve.mitre.org/). The database provides common identifiers that enable data exchange between security products, providing a baseline index point for evaluating coverage of tools and services.
- - The National Vulnerability Database (NVD) is the U.S. government repository of standards-based vulnerability management data. This data enables automation of vulnerability management, security measurement, and compliance. NVD includes databases of security checklists, security-related software flaws, misconfigurations, product names, and impact metrics. The database can be found at [http://nvd.nist.gov](http://nvd.nist.gov/)

## Classifying Countermeasures

One of these ways is based on the nature of the control itself:

- **Administrative:** These controls largely consist of policies and procedures. For instance, security awareness training, security policies and standards, change and configuration controls, security audits and tests, background checks of contractors and employees, and so on.
    
- **Technical:** These are controls that involve electronics, hardware, software, and so on. There are many examples: firewalls, intrusion prevention system (IPS) sensors, VPNs, biometrics, and others.
    
- **Physical:** These are controls that are mostly mechanical or that protect the physical infrastructure. Uninterruptible power supplies, fire suppression systems, positive air flow systems, locks, and security guards are examples.


## Managing Risk

![[Pasted image 20250213212541.png]]

The following are options for managing risk:

- _Risk acceptance_ is a common option when the cost of other risk management options such as avoidance may outweigh the cost of the risk itself.
    
- _Risk avoidance_ is the action that avoids any exposure to the risk. Risk avoidance is usually the most expensive risk mitigation option.
    
- _Risk limitation_ limits a company’s risk exposure by taking some action. It is a strategy employing a bit of risk acceptance along with a bit of risk avoidance. It is the most used risk mitigation strategy.
    
- _Risk transfer_ is the transference of risk to a willing third party (for example, an insurance company).

## Vulnerability Assessment

The table highlights some activities that are performed during the vulnerability assessment process:

| Device Discovery                                       | Service Enumeration                                          | Scanning                                                                            | Validation                                                                               |
| ------------------------------------------------------ | ------------------------------------------------------------ | ----------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- |
| - Identify<br>    <br>- Ping<br>    <br>- TCP SYN scan | - TCP ports<br>    <br>- UDP ports<br>    <br>- Web services | - Configuration issues<br>    <br>- Missing patches<br>    <br>- Dangerous services | - False positive removal<br>    <br>- Manual verification<br>    <br>- Review scan logic |

- **Device discovery:** During this phase different methods are used to identify servers, appliances, and other devices on the network.
    
- **Service enumeration:** In this phase vulnerability scanner tool identifies open ports and services available to each discovered system (such as mail and web servers).
    
- **Scanning:** Vulnerability assessment tool performs a port scan to determine what services are running on each active device. Determined services will help the vulnerability scanner to determine what types of vulnerability checks to run against a particular port. After the port scan, all hosts get scanned to identify vulnerabilities such as server misconfigurations, missed patches, and dangerous services.
    
- **Validation:** Some of the issues a vulnerability scanner discovers may be false positives. In some cases, these issues may be legitimate, but the issues may not be relevant because of other compensating controls the vulnerability scanner cannot account for.

Security professionals should frequently evaluate *Common Vulnerability Scoring System (CVSS)* for the purposes of understanding specific vulnerability characteristics and severity.

## Understanding CVSS

Common Vulnerability Scoring System - **CVSS** -  is an open framework for communicating the characteristics and severity of software vulnerabilities ([https://www.first.org/cvss](https://www.first.org/cvss)). CVSS scoring helps security professionals prioritize the specific vulnerabilities by vendor-defined severity, environment impact, and exploitability.

 Scores are calculated based on a formula utilizing several metrics that approximate ease of exploit and its impact. Scores range from 0 to 10, with 10 being the most severe.

The **CVSS model** is designed to provide the end user with an overall composite score representing the severity and risk of a vulnerability. It is derived from metrics and formulas.

The metrics are in three distinct categories that can be quantitatively or qualitatively measured:

- **Base metrics** contain qualities that are intrinsic to any given vulnerability that *do not change over time* or are in different environments.
     It is composed of two sets of metrics: 
     
     the **exploitability metrics** (attack vector, attack complexity, privileges required, user interaction, scope)
     and the **impact metrics** (confidentiality, integrity, availability).
 
- **Temporal metrics** contain characteristics of a vulnerability that *evolve over the lifetime of vulnerability*.
    **Exploit Code Maturity (E)**, **Remediation Level (RL)**, **Report Confidence (RC)** 

- **Environmental metrics** contain those characteristics of a vulnerability that are *tied to an implementation in a specific user environment*. 

**CVSS Calculator**: 

![[Pasted image 20250213224227.png]]

- **Attack Vector (AV):** This metric reflects the context by which vulnerability exploitation is possible. This metric value and the base score will correlate with an attacker's proximity to a vulnerable component. The score will be higher the more remote (logically and physically) an attacker is from the vulnerable component.
    
    1. **Local:** Exploiting the vulnerability requires either physical access to the target or a local (shell) account on the target.
        
    2. **Adjacent:** Exploiting the vulnerability requires access to the local network of the target and cannot be performed across an OSI Layer 3 boundary.
        
    3. **Network:** The vulnerability is exploitable from remote networks. Such a vulnerability is often termed "remotely exploitable," and can be thought of as an attack being exploitable one or more network hops away, such as across Layer 3 boundaries from routers.
        
    4. **Physical:** A vulnerability exploitable with physical access requires the attacker to physically touch and manipulate the vulnerable component.
        
- **Attack** **Complexity (AC):** This metric describes the conditions beyond the attacker's control that must exist to exploit the vulnerability.
    
    1. **Low:** Specialized access conditions or extenuating circumstances do not exist. An attacker can expect repeatable success against the vulnerable component.
        
    2. **High:** A successful attack depends on conditions beyond the attacker's control. That is, a successful attack cannot be accomplished at will, but requires the attacker to invest in some measurable amount of effort in preparation or execution against the vulnerable component before a successful attack can be expected.
        
- **Privileges Required (PR):** This metric describes the level of privileges an attacker must possess before successfully exploiting the vulnerability.
    
    1. **None:** The attacker is unauthorized before attack, and therefore does not require any access to settings or files to carry out an attack.
        
    2. **Low:** The attacker is authorized with privileges that provide basic user capabilities that could normally affect only settings and files that are owned by a user. Alternatively, an attacker with low privileges may have the ability to cause an impact only to non-sensitive resources only.
        
    3. **High:** The attacker is authorized with privileges that provide significant (for example, administrative) control over the vulnerable component that could affect component-wide settings and files.
        
- **User Interaction (UI):** This metric indicates whether a user other than the attacker must participate for the exploitation of a vulnerability to succeed.
    
    1. **None:** The vulnerable system can be exploited without interaction from any user.
        
    2. **Required:** Successful exploitation of this vulnerability requires a user to take some action before the vulnerability can be exploited.
        
- **Scope (S):** An important property that is captured by CVSS is the ability for a vulnerability in one software component to impact resources beyond its means, or privileges. This consequence is represented by the metric authorization scope.
    
    1. **Unchanged:** An exploited vulnerability can only affect resources that are managed by the same authority. In this case, the vulnerable component and the impacted component are the same.
        
    2. **Changed:** An exploited vulnerability can affect resources beyond the authorization privileges that are intended by the vulnerable component. In this case, the vulnerable component and the impacted component are different.
        
- **Confidentiality Impact (C):** This metric measures the impact to the confidentiality of the information resources that are managed by a software component due to a successfully exploited vulnerability. Confidentiality refers to limiting information access and disclosure to only authorized users, preventing access by, or disclosure to, unauthorized ones.
    
    1. **None:** There is no loss of confidentiality within the impacted component.
        
    2. **Low:** There is some loss of confidentiality. Access to some restricted information is obtained, but the attacker control over what information is obtained, or the amount or kind of loss is constrained. The information disclosure does not cause a direct, serious loss to the impacted component.
        
    3. **High:** There is total loss of confidentiality, resulting in all resources within the impacted component being divulged to the attacker. Alternatively, access to only some restricted information is obtained, but the disclosed information presents a direct, serious impact.
        
- **Integrity Impact (I):** This metric measures the impact to integrity of a successfully exploited vulnerability. Integrity refers to the trustworthiness and veracity of information.
    
    1. **None:** There is no loss of integrity within the impacted component.
        
    2. **Low**: Modification of data is possible, but the attacker does not control the consequence of a modification, or the amount of modification is constrained. The data modification does not have a direct, serious impact on the impacted component.
        
    3. **High:** There is a total loss of integrity, or a complete loss of protection. For example, the attacker is able to modify any or all files that are protected by the impacted component. Alternatively, only some files can be modified, but malicious modification would present a direct, serious consequence to the impacted component.
        
- **Availability Impact (A):** This metric measures the impact to the availability of the impacted component resulting from a successfully exploited vulnerability. While the confidentiality and integrity impact metrics apply to the loss of confidentiality or integrity of data such as information and files used by the impacted component, this metric refers to the loss of availability of the impacted component itself, such as a networked service such as web, database, and email. Because availability refers to the accessibility of information resources, attacks that consume network bandwidth, processor cycles, or disk space all impact the availability of an impacted component.
    
    1. **None:** There is no impact to availability within the impacted component.
        
    2. **Low:** There is reduced performance or interruptions in resource availability. Even if repeated exploitation of the vulnerability is possible, the attacker does not have the ability to completely deny service to legitimate users. The resources in the impacted component are either partially available all the time, or fully available only some of the time, but overall, there is no direct, serious consequence to the impacted component.
        
    3. **High:** There is total loss of availability, resulting in the attacker being able to fully deny access to resources in the impacted component; this loss is either sustained (while the attacker continues to deliver the attack) or persistent (the condition persists even after the attack has completed). Alternatively, the attacker has the ability to deny some availability, but the loss of availability presents a direct, serious consequence to the affected component. The attacker cannot disrupt existing connections but can prevent new connections. The attacker can repeatedly exploit a vulnerability that, in each instance of a successful attack, leaks only a small amount of memory but after repeated exploitation causes a service to become completely unavailable.






